<?php
/*
  Plugin Name: FreightDesk Online Extensibility Add-on
  Plugin URI: https://eniture.com/products/
  Description: Extends FreightDesk Online's capabilities with WooCommerce by options to add a  "Pro Pending" order status for 3PL shipments; insert tracking numbers and tracking links into the WooCommerce shipment notifications; propagate warehouses and boxes to FreightDesk Online.
  Author: Eniture Technology
  Author URI: https://eniture.com/
  Version: 1.0.0
  Text Domain: eniture-technology
  License: GPL version 2 or later - http://www.eniture.com/
  WC requires at least: 4.0.0
  WC tested up to: 4.9.0
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

add_action('before_woocommerce_init', function () {
  if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
      \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
  }
});

require_once 'vendor/autoload.php';

if (!class_exists('FdoOnlineShippingDetails')) {
  class FdoOnlineShippingDetails
  {
    public function __construct() 
    {
      add_filter('plugin_action_links', array($this, 'en_fdo_shipping_details_sttings_link'), 10, 5);
      add_filter('woocommerce_get_settings_pages', array($this, 'fdo_shipping_details_settings_pages'));
      add_action('admin_enqueue_scripts', array($this, 'en_fdo_shipping_details_script'));
    }

    function en_fdo_shipping_details_sttings_link($actions, $plugin_file)
    {
        if (!isset($plugin)) $plugin = plugin_basename(__FILE__);
        if ($plugin == $plugin_file) {
            $settings_link = wp_kses_post(sprintf(__('<a href="admin.php?page=wc-settings&tab=en_fdo_shipping_details">' . __('Settings', 'General') . '</a>')));
            $support_link = wp_kses_post(sprintf(__('<a href="https://eniture.com/support/" target="_blank">Support</a>')));
            $settings = array('settings' => $settings_link);
            $site_link = array('support' => $support_link);
            $actions = array_merge($settings, $actions);
            $actions = array_merge($site_link, $actions);
        }

        return $actions;
    }

    function fdo_shipping_details_settings_pages($settings)
    {
        include('includes/settings/settings-tab.php');
        return $settings;
    }

    /**
     * Load script
    */
    function en_fdo_shipping_details_script()
    {
        wp_register_style('en_fdo_shipping_details_style', plugin_dir_url(__FILE__) . '/assets/css/style.css', false, '1.0.0');
        wp_enqueue_style('en_fdo_shipping_details_style');
    }
  }

  new FdoOnlineShippingDetails();
}

new EnProNumber();
new EnSynchronizedData();

