<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

if (!class_exists('EnNmfcNumber')) {
    class EnNmfcNumber
    {
        public function __construct()
        {
            add_filter('en_group_package', array($this, 'en_group_package'), 10, 3);
            add_filter('en_fdo_package', array($this, 'en_fdo_package'), 10, 2);
            add_filter('en_fdo_carrier_service', array($this, 'en_fdo_carrier_service'), 10, 2);

            // Add simple product fields
            add_action('woocommerce_product_options_shipping', [$this, 'en_show_product_fields'], 101, 1);
            add_action('woocommerce_process_product_meta', [$this, 'en_save_product_fields'], 101, 1);

            // Add variable product fields.
            add_action('woocommerce_product_after_variable_attributes', [$this, 'en_show_product_fields'], 101, 1);
            add_action('woocommerce_save_product_variation', [$this, 'en_save_product_fields'], 101, 1);
        }

        /**
         * Set the product nmfc number to request
         */
        public function en_fdo_carrier_service($item, $item_data)
        {
            $en_nmfc_number = (isset($item_data['nmfc_number'])) ? $item_data['nmfc_number'] : '';
            $item['lineItemNMFC'] = $en_nmfc_number;
            return $item;
        }

        /**
         * Get the product nmfc number
         */
        public function en_group_package($item, $product_object, $product_detail)
        {
            $en_nmfc_number = $this->en_nmfc_number($product_object, $product_detail);
            $item['nmfc_number'] = $en_nmfc_number;
            return $item;
        }

        /**
         * Set the product nmfc number
         */
        public function en_fdo_package($item, $item_data)
        {
            $en_nmfc_number = (isset($item_data['nmfc_number'])) ? $item_data['nmfc_number'] : '';
            $item['nmfc_number'] = $en_nmfc_number;
            return $item;
        }

        /**
         * Get product shippable unit enabled
         */
        public function en_nmfc_number($product_object, $product_detail)
        {
            $post_id = (isset($product_object['variation_id']) && $product_object['variation_id'] > 0) ? $product_object['variation_id'] : $product_detail->get_id();
            return get_post_meta($post_id, '_nmfc_number', true);
        }

        /**
         * Show product fields in variation and simple product.
         * @param array $loop
         * @param array $variation_data
         * @param array $variation
         */
        public function en_show_product_fields($loop, $variation_data = [], $variation = [])
        {
            $postId = (isset($variation->ID)) ? $variation->ID : get_the_ID();
            $this->en_custom_product_fields($postId);
        }

        /**
         * Show Product Fields
         * @param int $postId
         */
        public function en_custom_product_fields($postId)
        {
            $en_product_fields = $this->en_product_fields_arr();

            foreach ($en_product_fields as $key => $custom_field) {
                $en_field_type = (isset($custom_field['type'])) ? $custom_field['type'] : '';
                $en_action_function_name = 'en_product_' . esc_attr($en_field_type);

                if (method_exists($this, $en_action_function_name)) {
                    $this->$en_action_function_name($custom_field, $postId);
                }
            }
        }

        /**
         * Save the simple product fields.
         * @param int $postId
         */
        public function en_save_product_fields($postId)
        {
            if (isset($postId) && $postId > 0) {
                $en_product_fields = $this->en_product_fields_arr();

                foreach ($en_product_fields as $key => $custom_field) {
                    $custom_field = (isset($custom_field['id'])) ? $custom_field['id'] : '';
                    $en_updated_product = (isset($_POST[$custom_field][$postId])) ? sanitize_text_field($_POST[$custom_field][$postId]) : '';
                    update_post_meta($postId, $custom_field, $en_updated_product);
                }
            }
        }

        /**
         * Product Fields Array
         * @return array
         */
        public function en_product_fields_arr()
        {
            $en_product_fields = [
                [
                    'type' => 'input_field',
                    'id' => '_nmfc_number',
                    'class' => '_nmfc_number short',
                    'label' => 'NMFC Number',
                    'description' => ''
                ]
            ];

            // We can use hook for add new product field from other plugin add-on
            $en_product_fields = apply_filters('en_echo_add_product', $en_product_fields);

            return $en_product_fields;
        }

        /**
         * Dynamic checkbox field show on product detail page
         * @param array $custom_field
         * @param int $postId
         */
        public function en_product_checkbox($custom_field, $postId)
        {
            $custom_checkbox_field = [
                'id' => $custom_field['id'] . '[' . $postId . ']',
                'value' => get_post_meta($postId, intval($custom_field['id']), true),
                'label' => esc_attr($custom_field['label']),
                'class' => esc_attr($custom_field['class']),
            ];

            if (isset($custom_field['description'])) {
                $custom_checkbox_field['desc_tip'] = true;
                $custom_checkbox_field['description'] = esc_attr($custom_field['description']);
            }

            woocommerce_wp_checkbox($custom_checkbox_field);
        }

        /**
         * Dynamic dropdown field show on product detail page
         * @param array $custom_field
         * @param int $postId
         */
        public function en_product_dropdown($custom_field, $postId)
        {
            $custom_dropdown_field = [
                'id' => $custom_field['id'] . '[' . $postId . ']',
                'label' => esc_attr($custom_field['label']),
                'class' => esc_attr($custom_field['class']),
                'value' => get_post_meta($postId, intval($custom_field['id']), true),
                'options' => esc_attr($custom_field['options'])
            ];

            if (isset($custom_field['description'])) {
                $custom_dropdown_field['desc_tip'] = true;
                $custom_dropdown_field['description'] = esc_attr($custom_field['description']);
            }

            woocommerce_wp_select($custom_dropdown_field);
        }

        /**
         * Dynamic input field show on product detail page
         * @param array $custom_field
         * @param int $postId
         */
        public function en_product_input_field($custom_field, $postId)
        {
            $custom_input_field = [
                'id' => $custom_field['id'] . '[' . $postId . ']',
                'label' => esc_attr($custom_field['label']),
                'class' => esc_attr($custom_field['class']),
                'placeholder' => esc_attr($custom_field['label']),
                'value' => get_post_meta($postId, $custom_field['id'], true)
            ];

            if (isset($custom_field['description'])) {
                $custom_input_field['desc_tip'] = true;
                $custom_input_field['description'] = esc_attr($custom_field['description']);
            }

            woocommerce_wp_text_input($custom_input_field);
        }
    }
}