<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly


if (!class_exists('EnProNumber')) {
    class EnProNumber
    {
        public function __construct()
        {
            // Register new custom status
            add_action('init', [$this, 'register_en_pro_pending_order_status']);
            // Add to list of WC Order statuses
            add_filter('wc_order_statuses', [$this, 'en_add_pro_pending_to_order_statuses']);

            add_action('woocommerce_email_order_meta', [$this, 'enfdo_add_custom_meta_to_email'], 10, 4);
            add_action('woocommerce_email_order_meta_text', [$this, 'enfdo_add_custom_meta_to_plain_text_email'], 10, 3);
        }

        public function enfdo_add_custom_meta_to_email($order, $sent_to_admin, $plain_text, $email) {
            $shipping_provider = get_post_meta($order->get_id(), 'enfdo_shipping_provider', true);
            $shipping_provider = !empty($shipping_provider) ? $shipping_provider : $order->get_meta('enfdo_shipping_provider');
            $tracking_number = get_post_meta($order->get_id(), 'enfdo_tracking_number', true);
            $tracking_number = !empty($tracking_number) ? $tracking_number : $order->get_meta('enfdo_tracking_number');
            $tracking_link = get_post_meta($order->get_id(), 'enfdo_tracking_link', true);
            $tracking_link = !empty($tracking_link) ? $tracking_link : $order->get_meta('enfdo_tracking_link');
    
            if (get_option('enable_tracking_info_fdo_shipping_details') == 'yes' && !empty($shipping_provider) && !empty($tracking_number)) {
                echo '<h2>' . __('Shipping Information', 'eniture-freightdesk-online-email-notification') . '</h2>';
                echo '<p><strong>' . __('Shipping Provider:', 'eniture-freightdesk-online-email-notification') . '</strong> ' . esc_html($shipping_provider) . '</p>';
                echo '<p><strong>' . __('Tracking Number:', 'eniture-freightdesk-online-email-notification') . '</strong> <a href="' . esc_url($tracking_link) . '" target="_blank">' . esc_html($tracking_number) . '</a></p>';
                if(!empty($tracking_link)){
                    echo '<p><strong>' . __('Tracking Link:', 'eniture-freightdesk-online-email-notification') . '</strong> <a href="' . esc_url($tracking_link) . '" target="_blank">' . esc_url($tracking_link) . '</a></p>';
                }
            }
        }

        public function enfdo_add_custom_meta_to_plain_text_email($order, $sent_to_admin, $plain_text) {
            $shipping_provider = get_post_meta($order->get_id(), 'enfdo_shipping_provider', true);
            $shipping_provider = !empty($shipping_provider) ? $shipping_provider : $order->get_meta('enfdo_shipping_provider');
            $tracking_number = get_post_meta($order->get_id(), 'enfdo_tracking_number', true);
            $tracking_number = !empty($tracking_number) ? $tracking_number : $order->get_meta('enfdo_tracking_number');
            $tracking_link = get_post_meta($order->get_id(), 'enfdo_tracking_link', true);
            $tracking_link = !empty($tracking_link) ? $tracking_link : $order->get_meta('enfdo_tracking_link');
    
            if (get_option('enable_tracking_info_fdo_shipping_details') == 'yes' && !empty($shipping_provider) && !empty($tracking_number)) {
                echo "\n\n" . __('Shipping Information', 'eniture-freightdesk-online-email-notification') . "\n";
                echo __('Shipping Provider:', 'eniture-freightdesk-online-email-notification') . ' ' . esc_html($shipping_provider) . "\n";
                echo __('Tracking Number:', 'eniture-freightdesk-online-email-notification') . ' ' . esc_html($tracking_number) . "\n";
                if(!empty($tracking_link)){
                    echo __('Tracking Link:', 'eniture-freightdesk-online-email-notification') . ' ' . esc_url($tracking_link) . "\n";
                }
            }
        }

        // Register new custom status
        function register_en_pro_pending_order_status()
        {
            if (get_option('enable_order_status_fdo_shipping_details') == 'yes') {
                register_post_status('wc-pro_pending', array(
                    'label' => 'PRO Pending',
                    'public' => true,
                    'show_in_admin_status_list' => true,
                    'show_in_admin_all_list' => true,
                    'exclude_from_search' => false,
                    'label_count' => _n_noop('PRO Pending <span class="count">(%s)</span>', 'PRO Pending <span class="count">(%s)</span>')
                ));
            }
        }

        // Add to list of WC Order statuses
        function en_add_pro_pending_to_order_statuses($order_statuses)
        {

            $new_order_statuses = array();

            // add new order status after processing
            foreach ($order_statuses as $key => $status) {

                $new_order_statuses[$key] = $status;

                if (get_option('enable_order_status_fdo_shipping_details') == 'yes' && 'wc-processing' === $key) {
                    $new_order_statuses['wc-pro_pending'] = 'PRO Pending';
                }
            }

            return $new_order_statuses;
        }
    }
}