<?php

// exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Woo-commerce Setting Tab Class
 */
class WC_Settings_FDO_Shipping_Details extends WC_Settings_Page
{
    /**
     * Woo-commerce Setting Tab Class Constructor
     */
    public function __construct()
    {
        $this->id = 'en_fdo_shipping_details';
        add_filter('woocommerce_settings_tabs_array', array($this, 'add_settings_tab'), 50);
        add_action('woocommerce_sections_' . $this->id, array($this, 'output_sections'));
        add_action('woocommerce_settings_' . $this->id, array($this, 'output'));
        add_action('woocommerce_settings_save_' . $this->id, array($this, 'save'));
    }

    /**
     * Setting Tab For Woo-commerce
     * @param $settings_tabs
     * @return string
     */
    function add_settings_tab($settings_tabs)
    {
        $settings_tabs[$this->id] = __('FreightDesk Online Extensibility Add-on', 'woocommerce-settings-fdo-shipping-details');
        return $settings_tabs;
    }

    /**
     * Setting Sections
     * @return array
     */
    function get_sections()
    {
        $sections = array(
            'settings' => __('Settings', 'woocommerce-settings-fdo-shipping-details'),
            'user-guide' => __('User Guide', 'woocommerce-settings-fdo-shipping-details'),
        );

        return apply_filters('woocommerce_get_sections_' . $this->id, $sections);
    }

    /**
     * Display all pages on wc settings tabs
     * @param $section
     * @return array
     */
    function get_settings($section = null)
    {
        ob_start();
        switch ($section) {
            case 'settings' :
                $settings = $this->settings();
                break;
            case 'user-guide' :
                $this->user_guide();
                $settings = [];
                break;
            default:
                $settings = $this->settings();
                break;
        }

        return apply_filters('woocommerce_get_settings_' . $this->id . '_' . $section, $settings);
    }

    /**
     WooCommerce Settings Tabs
     * @global $current_section
     */
    function output()
    {
        global $current_section;
        $settings = $this->get_settings($current_section);
        WC_Admin_Settings::output_fields($settings);
    }

    /**
     * Settings for FDO Shipping Details
    */
    function settings()
    {
      echo '<div class="en_fdo_shipping_details_section">';
      $settings = ['enable_order_status_fdo_shipping_details', 'enable_tracking_info_fdo_shipping_details'];

      // Enable the settings by default
      foreach ($settings as $setting) {
        if (empty(get_option($setting))) update_option($setting, 'yes');
      }

      $settings = array(
          'section_title' => array(
              'name' => __('Settings', 'woocommerce-settings-fdo-shipping-details'),
              'type' => 'title',
              'desc' => '',
              'id' => 'wc_en_fdo_shipping_details_section_title'
          ),
          'enable_order_status_fdo_shipping_details' => array(
              'name' => __('', 'woocommerce-settings-fdo-shipping-details'),
              'type' => 'checkbox',
              'desc' => __('Enable the "PRO Pending" order status for 3PL shipments.', 'woocommerce-settings-fdo-shipping-details'),
              'id' => 'enable_order_status_fdo_shipping_details',
          ),
          'enable_tracking_info_fdo_shipping_details' => array(
              'name' => __('', 'woocommerce-settings-fdo-shipping-details'),
              'type' => 'checkbox',
              'desc' => __('Add tracking information to the WooCommerce "Completed Order" email notifications.', 'woocommerce-settings-fdo-shipping-details'),
              'id' => 'enable_tracking_info_fdo_shipping_details',
          ),
          'section_end' => array(
              'type' => 'sectionend',
              'id' => 'wc_en_flat_rate_section_end'
          )
      );

      return $settings;
    }

    /**
     * User Guide Tab
    */
    function user_guide()
    {
      echo '<div class="fdo_shipping_details_user_guide">';
      echo '<h4>';
      echo 'FreightDesk Online extensibility add-on includes the following features:';
      echo '</h4>';
      echo '<ul style="list-style-type: disc;margin-left: 16px">';
      echo '<li>Add a "PRO Pending" order status for cases where there is a delay in the issuing of the shipment\'s PRO number. This is common for third-party logistics providers.</li>';
      echo '<li>Include the shipment tracking number in shipment email notifications that are sent to customers.</li>';
      echo '<li>Propagate defined box sizes from the WooCommerce plugin to FreightDesk Online.</li>';
      echo '<li>Propagate defined warehouses and dropship locations from the WooCommerce plugin to FreightDesk Online.</li>';
      echo '</ul>';
    }

    /**
     * Save Settings
     * @global $current_section
     */
    function save()
    {
        global $current_section;
        $settings = $this->get_settings($current_section);
        WC_Admin_Settings::save_fields($settings);
    }
}

return new WC_Settings_FDO_Shipping_Details();
