<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

if (!class_exists('EnSynchronizedData')) {
    class EnSynchronizedData
    {
        public function __construct()
        {
            add_action('rest_api_init', [$this, 'en_rest_api_init']);
        }

        // initialize the synchronization hook
        public function en_rest_api_init()
        {
            register_rest_route('synchronization', '/v1', array(
                'methods' => 'GET',
                'callback' => [$this, 'en_synchronized_data'],
                'permission_callback' => '__return_true',
            ));
            
            register_rest_route('synchronization', '/v2', array(
                'methods' => 'GET',
                'callback' => [$this, 'en_synchronized_data'],
                'permission_callback' => '__return_true',
            ));
        }

        /**
         * Get eniture plugins warehouses|boxes
         * @param array $request
         * @return array|void
         */
        public function en_synchronized_data($request)
        {
            if (isset($request['warehouses']) && $request['warehouses'] == 1) {

                global $wpdb;
                return $wpdb->get_results(
                    "SELECT * FROM " . $wpdb->prefix . "warehouse"
                );
            } else if (isset($request['boxes']) && $request['boxes'] == 1) {

                $boxes = [];
                $args = array('post_type' => ["box_sizing", "or_box_sizing"], 'posts_per_page' => -1);
                $query = new WP_Query($args);

                if ($query->have_posts()) {
                    while ($query->have_posts()) {
                        $query->the_post();
                        $postId = get_the_ID();
                        $box_sizing = get_post_meta($postId, 'box_sizing', true);
                        $or_box_sizing = get_post_meta($postId, 'or_box_sizing', true);

                        if (!empty($box_sizing) && is_array($box_sizing)) {
                            $box_sizing['id'] = $postId;
                            $boxes['box_sizing'][] = $box_sizing;
                        }
                        if (!empty($or_box_sizing) && is_array($or_box_sizing)) {
                            $or_box_sizing['id'] = $postId;
                            $boxes['or_box_sizing'][] = $or_box_sizing;
                        }
                    }
                }

                return $boxes;
            }  else if (isset($request['pallets']) && $request['pallets'] == 1) {
                global $wpdb;
                return $wpdb->get_results("SELECT * FROM {$wpdb->prefix}en_pallets");
            }
        }
    }
}

